/* Filename : macros.h
 * Author   : Philippe Waelti <philippe.waelti@eivd.ch>
 * Date     : 2003-07-04
 * Goal     : Macros definitions
 *
 *            Part of QualOpt project from the HES-SO, QUALOPT-11731,
 *            Switzerland.
 *
 * Remarks  : ISO conform (-ansi -pedantic)
 */

/* ------------------------------------------------------------------------ */

#ifndef _MACRO_H
#define _MACRO_H

/* ------------------------------------------------------------------------ */

/* long double absolute value */
#define LABS(x) ( (x) > 0.0 ? (x) : -(x) )

/* ------------------------------------------------------------------------ */

/* max value */
#define MAX(x,y) ( (x) > (y) ? (x) : (y) )

/* ------------------------------------------------------------------------ */

/* min value */
#define MIN(x,y) ( (x) < (y) ? (x) : (y) )

/* ------------------------------------------------------------------------ */

#endif

/* ------------------------------------------------------------------------ */

