/* Filename : STATSTest.java
 * Author   : Philippe Waelti <philippe.waelti@eivd.ch>
 * Date     : 2003-07-04
 * Goal     : Test the implementation of the 'Statistical Test for Comparing
 *            Success Rates' (STATS Library).
 *
 *            Part of QualOpt project from the HES-SO, QUALOPT-11731,
 *            Switzerland.
 */

import java.io.*;

public class STATSTest {

    /* Welcome message */
    private static void printWelcome() {
        System.out.println("\nA Statistical Test to Compare Success Rates");
        System.out.println("===========================================");
        System.out.println(" Let the sample 1 have a success rate of a/n");
        System.out.println(" and sample 2 have a success rate of b/m :");
    }

    /* Main */
    public static void main(String[] args) {

        /* Parameters */
        int a = 0, n = 0, b = 0, m = 0;

        /* Temp integer */
        Integer read;

        /*  Open a buffer */
        BufferedReader br =
            new BufferedReader(new InputStreamReader(System.in));

        printWelcome();

        try {

            System.out.println();

            System.out.print("Enter a : ");
            read = new Integer(br.readLine());
            a    = read.intValue();

            System.out.print("Enter n : ");
            read = new Integer(br.readLine());
            n    = read.intValue();

            System.out.println();

            System.out.print("Enter b : ");
            read = new Integer(br.readLine());
            b    = read.intValue();

            System.out.print("Enter m : ");
            read = new Integer(br.readLine());
            m    = read.intValue();

            System.out.println();

        } catch (Exception e) {

            System.out.println("IO error\n");
            System.exit(1);

        }

        try {

            double S = STATS.taillardOneTailed(a, n, b, m);

            System.out.println("[ Taillard Test :: One-Tailed Test ]\n");
            System.out.println("The p-value (significance level) " +
                "associated with null hypothesis\nis " + S + ". " +
                "Confidence level of alternate hypothesis\n(sample 1 " +
                "has a success rate higher than sample 2) : " +
                (1.0 - S) + "\n");

            double T = STATS.taillardTwoTailed(a, n, b, m);

            System.out.println("[ Taillard Test :: Two-Tailed Test ]\n");
            System.out.println("The p-value (significance level) " +
                "associated with null hypothesis\nis " + T + ". " +
                "Confidence level of alternate hypothesis\n(sample 1 " +
                "has a success rate different to sample 2) : " +
                (1.0 - T) + "\n\n");

            S = STATS.fisherOneTailed(a, n, b, m);

            System.out.println("[ Fisher Test :: One-Tailed Test ]\n");
            System.out.println("The p-value (significance level) " +
                "associated with null hypothesis\nis " + S + ". " +
                "Confidence level of alternate hypothesis\n(sample 1 " +
                "has a success rate higher than sample 2) : " +
                (1.0 - S) + "\n");

            T = STATS.fisherTwoTailed(a, n, b, m);

            System.out.println("[ Fisher Test :: Two-Tailed Test ]\n");
            System.out.println("The p-value (significance level) " +
                "associated with null hypothesis\nis " + T + ". " +
                "Confidence level of alternate hypothesis\n(sample 1 " +
                "has a success rate different to sample 2) : " +
                (1.0 - T) + "\n\n");

        } catch (STATSException e) {

            System.out.println(e.getDescription() + "\n");
            System.exit(1);

        }

        /* Exit */
        System.exit(0);

    }
}


