/* Filename : STATSGui.java
 * Author   : Philippe Waelti <philippe.waelti@eivd.ch>
 * Date     : 2003-07-30
 * Goal     : GUI for the statistical test graphical implementation
 *
 *            Part of QualOpt project from the HES-SO, QUALOPT-11731,
 *            Switzerland.
 *
 * TODO     : JavaDoc
 */


import java.awt.*;
import java.awt.event.*;

public class STATSGui implements ActionListener {

    /* Buttons */
    private Button btnComp = new Button("Compute");
    private Button btnQuit = new Button("Quit");

    /* Text fields */
    private TextField txtA = new TextField("", 3);
    private TextField txtN = new TextField("", 3);
    private TextField txtB = new TextField("", 3);
    private TextField txtM = new TextField("", 3);

    private TextField txtTaillard = new TextField("", 1);
    private TextField txtFisher = new TextField("", 1);

    private TextField txtST = new TextField("", 1);
    private TextField txtTT = new TextField("", 1);

    private TextField txtSF = new TextField("", 1);
    private TextField txtTF = new TextField("", 1);

    /* Grid layout */
    private GridBagLayout gridBag = new GridBagLayout();

    /* Parent container */
    private Container parent;

    /* Constructor */
    public STATSGui(Container parent) {

        /* Register parent */
        this.parent = parent;

        /* Set parent layout */
        parent.setLayout(gridBag);

        /* Action listener */
        btnComp.addActionListener(this);
        btnQuit.addActionListener(this);

        /* Initialize controls */
        btnComp.setBackground(Color.lightGray);
        btnQuit.setBackground(Color.lightGray);

        txtA.setBackground(Color.white);
        txtN.setBackground(Color.white);
        txtB.setBackground(Color.white);
        txtM.setBackground(Color.white);

        txtTaillard.setBackground(Color.lightGray);
        txtFisher.setEditable(false);
        txtST.setBackground(Color.lightGray);
        txtST.setEditable(false);
        txtTT.setBackground(Color.lightGray);
        txtTT.setEditable(false);
        txtSF.setBackground(Color.lightGray);
        txtSF.setEditable(false);
        txtTF.setBackground(Color.lightGray);
        txtTF.setEditable(false);

        /* Add component */

        // Line 1
        constrain(new Label("Statistical test for proportions comparison"),
            parent, 1, 1, 5, 1, 10, 10, 10, 10);

        // Line 2
        constrain(new Label("A"), parent, 1, 2, 1, 1, 10, 10, 10, 0);
        constrain(txtA, parent,           2, 2, 1, 1, 10, 10, 10, 0);

        // Line 3
        constrain(new Label("N"), parent, 1, 3, 1, 1, 10, 10, 10, 0);
        constrain(txtN, parent,           2, 3, 1, 1, 10, 10, 10, 0);

        // Line 4
        constrain(new Label("B"), parent, 1, 4, 1, 1, 10, 10, 10, 0);
        constrain(txtB, parent,           2, 4, 1, 1, 10, 10, 10, 0);

        // Line 5
        constrain(new Label("M"), parent, 1, 5, 1, 1, 10, 10, 10, 0);
        constrain(txtM, parent,           2, 5, 1, 1, 10, 10, 10, 0);

        // Line 6
        constrain(new Label("[Taillard Test]"), parent, 1, 6, 1, 1, 10, 10,
            10, 0);

        // Line 7
        constrain(new Label("S = "), parent, 1, 7, 1, 1, 10, 10, 10, 0);
        constrain(txtST, parent,             2, 7, 4, 1, 10, 10, 10, 10);

        // Line 8
        constrain(new Label("T = "), parent, 1, 8, 1, 1, 10, 10, 10, 0);
        constrain(txtTT, parent,             2, 8, 4, 1, 10, 10, 10, 10);

        // Line 9
        constrain(new Label("[Fisher Test]"), parent, 1, 9, 1, 1, 10, 10,
            10, 0);

        // Line 10
        constrain(new Label("S = "), parent, 1, 10, 1, 1, 10, 10, 10, 0);
        constrain(txtSF, parent,             2, 10, 4, 1, 10, 10, 10, 10);

        // Line 11
        constrain(new Label("T = "), parent, 1, 11, 1, 1, 10, 10, 10, 0);
        constrain(txtTF, parent,             2, 11, 4, 1, 10, 10, 10, 10);

        // Line 12
        constrain(btnComp, parent, 1, 12, 2, 1, 10, 10, 10, 0);
        constrain(btnQuit, parent, 3, 12, 2, 1, 10, 10, 10, 0);


    }

    /* Action handler */
    public void actionPerformed(ActionEvent event) {

        /* Compute button */
        if (event.getSource() == btnComp) {

            int a, b, n, m;

            try {
                a = (new Integer((txtA.getText())).intValue());
                n = (new Integer((txtN.getText())).intValue());
                b = (new Integer((txtB.getText())).intValue());
                m = (new Integer((txtM.getText())).intValue());

            } catch (Exception e) {

                txtST.setText("Type error in values");
                return;
            }

            try {

                txtST.setText(
                    (new Double(STATS.taillardOneTailed(a, n, b, m)).toString()));

                txtTT.setText(
                    (new Double(STATS.taillardTwoTailed(a, n, b, m)).toString()));

                txtSF.setText(
                    (new Double(STATS.fisherOneTailed(a, n, b, m)).toString()));

                txtTF.setText(
                    (new Double(STATS.fisherTwoTailed(a, n, b, m)).toString()));

            } catch (STATSException e) {

                txtST.setText(e.getDescription());
                return;

            }

        /* Quit button */
        } else if (event.getSource() == btnQuit) {

            System.exit(0);

        }
    }

    /* Place a component in a grid layout */
    private void constrain(Component component, Container c,
            int gridX, int gridY, int width, int height, int topMargin,
            int leftMargin, int bottomMargin, int rightMargin) {

        GridBagConstraints constraints = new GridBagConstraints();

        constraints.gridx  = gridX;
        constraints.gridy  = gridY;
        constraints.gridwidth  = width;
        constraints.gridheight = height;
        constraints.fill   = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;
        constraints.insets =
            new Insets(topMargin, leftMargin, bottomMargin, rightMargin);

        ((GridBagLayout)c.getLayout()).setConstraints(component, constraints);

        c.add(component);

    }
}

