/**
 * <p>Bad Arguments STATS exception class. This exception is raised when
 * bad arguments in the statistical test occurs. </p>
 *
 * <p> Part of QualOpt project from the HES-SO, QUALOPT-11731,
 * Switzerland.</p>
 *
 * @author  Philippe Waelti / &lt;philippe.waelti at heig-vd.ch&gt;
 * @version 0.20
 * @since   0.10
 */
public class STATSBadArgsException extends STATSException {

    /** Initalize Bad Arguments Exception with no special comment */
    public STATSBadArgsException() {
        message = "STATS Bad Arguments Exception";
    }

    /** Initalize Bad Arguments Exception with a given comment
     * @param err   Details about the exception
     */
    public STATSBadArgsException(String err) {
        message = "STATS Bad Arguments Exception";
        comment = new String(err);
    }
}

