/**
 * <p> Definiton of the main STATS exception class. </p>
 *
 * <p> Part of QualOpt project from the HES-SO, QUALOPT-11731,
 * Switzerland.</p>
 *
 * @author  Philippe Waelti / &lt;philippe.waelti at heig-vd.ch&gt;
 * @version 0.20
 * @since   0.10
 */
public abstract class STATSException extends Exception {

    /** Description of the exception */
    protected String message = "STATS Exception";

    /** Comment for the exception (May be raise details for example) */
    protected String comment = "";

    /** STATS Exception constructor */
    public STATSException() {}

    /** Return a string description of the exception */
    String getDescription() {
        return message;
    }

    /** Return details for the exception */
    String getComment() {
        return comment;
    }

}

