/**
 * <p>Memory STATS exception class. This exception is raised when
 * a memory error in the statistical test occurs. </p>
 *
 * <p> Part of QualOpt project from the HES-SO, QUALOPT-11731,
 * Switzerland.</p>
 *
 * @author  Philippe Waelti / &lt;philippe.waelti at heig-vd.ch&gt;
 * @version 0.20
 * @since   0.10
 */
public class STATSMemoryException extends STATSException {

    /** Initalize Memory Exception with no special comment */
    public STATSMemoryException() {
        message = "STATS Memory Exception";
    }

    /** Initalize Memory Exception with a given comment
     * @param err   Details about the exception
     */
    public STATSMemoryException(String err) {
        message = "STATS Memory Exception";
        comment = new String(err);
    }
}

